CREATE DATABASE  IF NOT EXISTS `reservas` /*!40100 DEFAULT CHARACTER SET latin1 */;
USE `reservas`;
-- MariaDB dump 10.17  Distrib 10.4.10-MariaDB, for Win64 (AMD64)
--
-- Host: 127.0.0.1    Database: reservas
-- ------------------------------------------------------
-- Server version	10.4.10-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `pistas`
--

DROP TABLE IF EXISTS `pistas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pistas` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `codigo` varchar(10) NOT NULL,
  `tipo` enum('tenis','futbol','baloncesto','ping-pong') DEFAULT NULL,
  `precio` float DEFAULT 0,
  `id_polideportivo` int(10) DEFAULT NULL,
  `veces_reservada` int(11) DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `codigo` (`codigo`),
  KEY `id_polideportivo` (`id_polideportivo`),
  CONSTRAINT `pistas_ibfk_1` FOREIGN KEY (`id_polideportivo`) REFERENCES `polideportivos` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=201 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pistas`
--

LOCK TABLES `pistas` WRITE;
/*!40000 ALTER TABLE `pistas` DISABLE KEYS */;
INSERT INTO `pistas` VALUES (1,'NVAW5851','baloncesto',8.03,13,1),(2,'SKRB6837','tenis',6.17,4,2),(3,'OSDW1028','futbol',6.76,18,0),(4,'ISUM9115','baloncesto',5.31,27,1),(5,'RAUE1955','tenis',6.26,26,1),(6,'YLOC9758','tenis',5.39,3,0),(7,'VNPE8442','tenis',8.14,21,0),(8,'OEYW9491','futbol',9.53,11,0),(9,'KKSR8766','futbol',NULL,21,1),(10,'CEGB4252','futbol',7.59,28,0),(11,'MIFY5582','futbol',8.23,31,0),(12,'TJQD9919','baloncesto',8.41,16,2),(13,'OZRQ7865','tenis',7.32,22,0),(14,'LSNF7568','futbol',6.41,3,0),(15,'MUVF2634','baloncesto',5.06,2,3),(16,'OPTY1027','tenis',6.07,25,1),(17,'TKUX0465','baloncesto',5.18,15,1),(18,'TJKE8777','tenis',NULL,19,1),(19,'BNQA5990','tenis',7.87,14,0),(20,'JKIS1458','futbol',6.33,29,1),(21,'SPST7163','baloncesto',8.01,9,1),(22,'SWEE9627','tenis',6.08,1,1),(23,'WULM9254','ping-pong',6.37,27,0),(24,'KMRJ2670','ping-pong',8.62,26,1),(25,'PUQX9051','futbol',8.97,1,0),(26,'XOOO6935','baloncesto',9.02,4,2),(27,'RYLX1194','baloncesto',NULL,15,1),(28,'TGZD7855','futbol',8.74,23,2),(29,'OTAG0169','baloncesto',9.22,32,1),(30,'IAKJ5677','futbol',9.88,30,0),(31,'XLVU0059','futbol',6.73,31,2),(32,'DRYW8811','tenis',9.01,3,2),(33,'SVEJ2873','futbol',9.87,24,1),(34,'TQXA0519','baloncesto',7.3,10,2),(35,'ERWI4640','ping-pong',6.89,32,0),(36,'RSWG6120','ping-pong',NULL,28,0),(37,'APNE1149','ping-pong',7.12,4,2),(38,'UFYH1995','ping-pong',7.93,9,0),(39,'STJY1092','ping-pong',8.27,16,1),(40,'MKHF8324','ping-pong',7.56,27,2),(41,'WXMD6983','tenis',8,19,1),(43,'HNCH9349','baloncesto',7.3,23,1),(45,'TCSV5439','ping-pong',NULL,11,2),(47,'DEXD8225','tenis',5.63,8,1),(48,'GYRZ9093','futbol',5.65,3,0),(50,'EIHT9322','ping-pong',6.35,17,0),(51,'YGOB8648','futbol',9.78,16,1),(52,'UVLL6678','futbol',9.88,14,1),(53,'HDVY3293','ping-pong',5.06,18,1),(54,'IWJT3772','tenis',NULL,27,0),(55,'IZFN4987','tenis',8.08,17,0),(56,'MCJK7836','tenis',8.44,6,1),(57,'KXZO0644','ping-pong',7.98,5,1),(58,'JROC6715','ping-pong',9.55,6,3),(59,'STNM8369','futbol',8.82,32,2),(60,'ETHE3225','futbol',5.45,19,2),(61,'IKWF0936','tenis',5.78,10,1),(62,'CMBN6909','baloncesto',7.58,6,1),(63,'NTZQ0385','tenis',NULL,28,0),(64,'IJYW3680','futbol',9.95,24,0),(65,'GYAX6819','ping-pong',8.12,27,3),(66,'CEGQ5643','futbol',5.78,9,1),(67,'JWIO2960','futbol',9.54,9,1),(68,'KHAA2434','baloncesto',5.36,10,1),(69,'CZQE7103','tenis',8.18,8,2),(70,'UZOU1013','ping-pong',9.83,10,0),(71,'BVNF4869','baloncesto',9.58,8,1),(72,'CXMA8426','tenis',NULL,3,1),(73,'MYBC2352','futbol',8.43,11,2),(74,'KMCF2985','ping-pong',6.82,17,1),(75,'FFJH7299','tenis',8.84,11,0),(76,'QULX2495','tenis',8.72,4,0),(77,'USIQ5683','ping-pong',7.1,15,0),(78,'MSXR3874','baloncesto',9.32,10,1),(79,'GCAM3362','tenis',5.29,6,0),(80,'MSRO0155','ping-pong',8.52,19,0),(81,'OJRJ1952','tenis',NULL,2,1),(82,'SDZC3780','tenis',8.1,10,0),(83,'ZLGZ0732','tenis',5.29,24,1),(84,'VOPF6988','futbol',7.15,1,2),(85,'JWAA6818','futbol',9.88,28,1),(86,'FYTB3376','baloncesto',7.94,10,2),(87,'XPOR6311','futbol',5.06,24,1),(88,'DHWH1743','tenis',6.47,7,2),(89,'SSCT6428','baloncesto',7.17,6,2),(90,'CZRE5697','ping-pong',NULL,7,0),(91,'DJMN9021','futbol',5.78,21,1),(92,'XIFV4529','baloncesto',9.54,2,1),(93,'FLZC4447','futbol',5.36,23,0),(94,'XWCA6969','futbol',8.15,31,1),(95,'YFRW6460','tenis',9.68,1,1),(96,'RRLK6971','futbol',8.97,8,3),(97,'SCOZ1469','futbol',5.79,12,0),(98,'NUYD1885','ping-pong',7.05,1,2),(99,'VCUU1800','tenis',NULL,14,0),(100,'MLUZ2097','tenis',8.15,6,0),(101,'SDBU9999','ping-pong',7.19,15,1),(103,'YUCU6965','futbol',6.47,9,1),(105,'KCVK8721','tenis',5.81,23,0),(106,'VJPZ6661','baloncesto',9.62,31,2),(107,'NYCX6716','ping-pong',5.66,8,1),(108,'ECTQ0206','futbol',NULL,15,1),(109,'FITT8107','ping-pong',5.22,10,0),(110,'FTKY0794','tenis',7.77,29,2),(111,'OSGA2573','ping-pong',8.22,16,2),(112,'LMTV8553','ping-pong',7.77,31,0),(113,'XXAM6850','futbol',9.21,4,1),(114,'JYFS9994','tenis',7.74,25,3),(115,'VSJR4412','ping-pong',6.06,27,1),(117,'NVHV4595','tenis',NULL,17,1),(118,'UJKA7251','tenis',7.21,26,1),(119,'ODWL1802','ping-pong',9.83,5,0),(120,'YNQZ9172','tenis',7.51,11,0),(121,'PNPG5263','ping-pong',8.08,6,3),(122,'RKAT8162','tenis',7.84,23,3),(123,'EVJJ4685','tenis',9.99,27,0),(124,'AWHO0252','futbol',6.41,11,0),(125,'VIAB3512','tenis',7.08,26,0),(126,'NAFK1829','futbol',NULL,21,2),(127,'USPT3296','tenis',9.57,10,0),(128,'IAAZ6453','ping-pong',9.39,2,1),(129,'CBHX7228','ping-pong',8.22,30,2),(130,'LKTV4744','tenis',7.96,14,0),(131,'LPUW5218','baloncesto',5.1,15,1),(132,'TSRQ1053','tenis',6.64,11,1),(133,'YAAZ0586','tenis',7.9,16,3),(135,'BQNL5187','ping-pong',NULL,1,1),(136,'PWKE8873','futbol',9.25,18,1),(137,'PZAT9482','ping-pong',7.46,2,2),(138,'UJUM5112','tenis',9.56,1,2),(139,'SKQV6549','baloncesto',5.43,7,2),(140,'EUYU8891','tenis',8.44,22,1),(141,'CMTH5532','tenis',5.95,17,1),(142,'ARSL7828','baloncesto',9.4,32,1),(143,'LCVD2975','tenis',9.16,28,1),(144,'VERL7456','futbol',NULL,32,0),(145,'NNYS5349','futbol',5.45,6,1),(146,'OQDQ5273','ping-pong',9.52,5,2),(147,'GZLL8098','futbol',6.22,22,0),(148,'RPLX2191','ping-pong',7.54,3,2),(149,'TUSP9507','baloncesto',9.06,6,3),(150,'WQDO7235','baloncesto',7.69,5,4),(151,'TIUX0148','tenis',6.26,15,0),(152,'QIKZ3605','futbol',8.21,5,0),(153,'IDJO0763','futbol',NULL,28,0),(154,'QJBK3836','ping-pong',6.79,14,2),(155,'JMTH2810','baloncesto',7.11,16,1),(156,'DHQS9490','futbol',5.16,28,2),(157,'EONV8991','ping-pong',9.47,2,2),(158,'SUJU1016','futbol',6.88,13,1),(159,'RGFR4996','ping-pong',6,19,2),(161,'VBGB5048','futbol',9.35,7,1),(162,'JVSJ2806','tenis',NULL,12,1),(163,'FKXS9506','baloncesto',5.65,20,1),(164,'RPFI0665','baloncesto',7.04,20,1),(165,'IRRM0485','futbol',8.26,14,0),(167,'WPZW3069','baloncesto',5.18,11,2),(168,'BKIW0763','ping-pong',6.11,31,2),(169,'YUXH9242','ping-pong',5,15,2),(170,'ZEUY9211','tenis',6.7,8,0),(171,'EUFT7260','futbol',NULL,25,0),(172,'PYOF5789','futbol',7.26,17,2),(173,'SDCL5236','futbol',5.88,2,0),(174,'KWBQ2088','ping-pong',7.63,17,0),(175,'ZNLE2759','baloncesto',5.5,31,2),(176,'YNOQ5445','baloncesto',9.6,11,1),(177,'EMWH2993','futbol',6.52,30,0),(178,'DQZP1636','baloncesto',8.78,7,2),(179,'ALBB9418','ping-pong',9.37,2,2),(180,'KZVT0850','ping-pong',NULL,12,1),(181,'XZPE8797','tenis',9.36,3,0),(182,'TYLK5810','tenis',5.32,13,1),(183,'BLTI1591','tenis',8.53,28,1),(184,'LSUG9297','ping-pong',6.68,5,1),(185,'TSZW0054','futbol',7.83,14,1),(186,'GAIE3510','futbol',9.1,21,3),(187,'ZBXC8186','tenis',7.01,1,0),(188,'AETS5815','baloncesto',7.74,17,1),(189,'TFLR3327','ping-pong',NULL,8,1),(190,'WVOW5205','futbol',5.18,16,0),(191,'ZURE9669','baloncesto',7.85,26,3),(192,'ZSMT7981','tenis',8.72,10,0),(193,'ZRXB5080','futbol',5.04,27,1),(194,'MRRC5495','futbol',9.02,17,1),(195,'TJQU2476','tenis',5.02,15,0),(196,'BOAG0796','ping-pong',8.01,1,1),(197,'EBMT4445','tenis',10,7,1),(198,'TVQS0855','baloncesto',NULL,22,2),(199,'ZYKY5229','futbol',9.77,26,4),(200,'RMXR7604','futbol',5.97,10,1);
/*!40000 ALTER TABLE `pistas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pistas_abiertas`
--

DROP TABLE IF EXISTS `pistas_abiertas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pistas_abiertas` (
  `id_pista` int(10) NOT NULL,
  `operativa` tinyint(1) NOT NULL DEFAULT 1,
  `fecha_ultima_reserva` datetime DEFAULT NULL,
  `proxima_revision` datetime NOT NULL,
  PRIMARY KEY (`id_pista`),
  KEY `id_pista` (`id_pista`),
  CONSTRAINT `pistas_abiertas_ibfk_1` FOREIGN KEY (`id_pista`) REFERENCES `pistas` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pistas_abiertas`
--

LOCK TABLES `pistas_abiertas` WRITE;
/*!40000 ALTER TABLE `pistas_abiertas` DISABLE KEYS */;
INSERT INTO `pistas_abiertas` VALUES (1,1,'2022-04-23 14:09:06','2023-04-23 14:09:06'),(2,1,'2022-08-25 00:42:38','2024-08-25 00:42:38'),(3,1,'2021-12-14 19:35:07','2022-12-14 19:35:07'),(4,1,'2022-06-07 15:56:10','2024-06-07 15:56:10'),(5,1,'2023-08-08 11:07:43','2023-08-08 11:07:43'),(6,1,NULL,'2024-08-15 03:32:15'),(7,1,'2022-03-26 17:03:52','2023-03-26 17:03:52'),(8,1,'2021-11-22 01:19:39','2023-11-22 01:19:39'),(9,1,'2022-12-17 16:30:49','2023-12-17 16:30:49'),(10,1,'2022-07-29 11:36:36','2024-07-29 11:36:36'),(11,1,'2022-01-21 17:26:29','2023-01-21 17:26:29'),(12,1,NULL,'2024-03-13 17:40:27'),(13,1,'2023-09-25 15:02:12','2023-09-25 15:02:12'),(14,1,'2022-07-14 06:02:59','2024-07-14 06:02:59'),(15,1,'2022-03-23 10:31:15','2023-03-23 10:31:15'),(16,1,'2022-11-09 09:46:59','2024-11-09 09:46:59'),(17,1,'2023-04-09 14:13:29','2023-04-09 14:13:29'),(18,1,NULL,'2024-01-06 19:53:05'),(19,1,'2022-01-02 10:07:15','2023-01-02 10:07:15'),(26,1,'2022-09-28 16:19:50','2024-09-28 16:19:50'),(27,1,'2023-08-10 09:40:43','2023-08-10 09:40:43'),(28,1,'2023-08-03 05:33:29','2024-08-03 05:33:29'),(29,1,'2022-06-18 06:34:43','2023-06-18 06:34:43'),(30,1,NULL,'2024-11-18 05:38:36'),(31,1,'2023-05-20 04:08:48','2023-05-20 04:08:48'),(32,1,'2022-04-20 15:27:52','2024-04-20 15:27:52'),(33,1,'2022-02-08 15:44:03','2023-02-08 15:44:03'),(34,1,'2022-05-08 23:00:44','2024-05-08 23:00:44'),(35,1,'2022-04-18 01:36:55','2023-04-18 01:36:55'),(36,1,NULL,'2024-11-22 06:41:32'),(37,1,'2022-04-12 15:21:29','2023-04-12 15:21:29'),(38,1,'2022-04-24 00:08:42','2024-04-24 00:08:42'),(39,1,'2022-12-16 12:34:37','2023-12-16 12:34:37'),(40,1,'2022-05-17 18:32:35','2024-05-17 18:32:35'),(41,1,'2022-03-19 14:46:03','2023-03-19 14:46:03'),(43,1,'2023-10-28 22:48:38','2023-10-28 22:48:38'),(45,1,'2021-12-29 03:13:18','2022-12-29 03:13:18'),(47,1,'2022-06-18 03:31:04','2023-06-18 03:31:04'),(48,1,NULL,'2024-06-03 01:28:27'),(50,1,'2022-05-02 02:28:23','2024-05-02 02:28:23'),(51,1,'2022-03-11 06:41:47','2023-03-11 06:41:47'),(52,1,'2022-03-16 08:51:23','2024-03-16 08:51:23'),(53,1,'2022-04-13 17:33:52','2023-04-13 17:33:52'),(54,1,NULL,'2024-10-04 08:48:22'),(55,1,'2023-01-05 09:25:29','2023-01-05 09:25:29'),(56,1,'2022-11-06 11:55:21','2024-11-06 11:55:21'),(57,1,'2023-02-04 11:20:28','2023-02-04 11:20:28'),(58,1,'2022-09-16 01:02:05','2024-09-16 01:02:05'),(59,1,'2023-07-03 02:48:53','2023-07-03 02:48:53'),(60,1,NULL,'2024-03-08 02:30:27'),(61,1,'2021-12-03 04:01:20','2022-12-03 04:01:20'),(62,1,'2022-11-03 19:32:11','2024-11-03 19:32:11'),(63,1,'2023-10-12 04:16:43','2023-10-12 04:16:43'),(64,1,'2022-02-12 06:00:27','2024-02-12 06:00:27'),(65,1,'2023-03-27 07:29:54','2023-03-27 07:29:54'),(66,1,NULL,'2023-11-19 07:17:47'),(67,1,'2022-10-10 13:44:26','2023-10-10 13:44:26'),(68,1,'2023-01-14 09:25:46','2024-01-14 09:25:46'),(69,1,'2021-10-30 23:04:43','2022-10-30 23:04:43'),(70,1,'2023-11-23 06:36:33','2024-11-23 06:36:33'),(71,1,'2022-11-02 17:39:56','2023-11-02 17:39:56'),(72,1,NULL,'2024-05-07 20:20:54'),(73,1,'2022-05-30 04:59:45','2023-05-30 04:59:45'),(74,1,'2022-05-06 02:56:46','2024-05-06 02:56:46'),(75,1,'2023-10-03 02:11:50','2023-10-03 02:11:50'),(76,1,'2023-05-24 20:56:07','2024-05-24 20:56:07'),(77,1,'2022-01-06 08:43:28','2023-01-06 08:43:28'),(78,1,NULL,'2024-06-01 07:49:53'),(79,1,'2022-05-21 11:18:06','2023-05-21 11:18:06'),(80,1,'2023-10-17 02:11:01','2024-10-17 02:11:01'),(81,1,'2022-09-10 21:34:06','2023-09-10 21:34:06'),(82,1,'2021-11-16 02:34:30','2023-11-16 02:34:30'),(83,1,'2023-09-25 20:37:17','2023-09-25 20:37:17'),(84,1,NULL,'2024-01-09 23:45:40'),(85,1,'2023-08-24 04:47:30','2023-08-24 04:47:30'),(86,1,'2023-07-14 03:01:17','2024-07-14 03:01:17'),(87,1,'2021-12-28 16:53:35','2022-12-28 16:53:35'),(88,1,'2021-12-24 02:53:11','2023-12-24 02:53:11'),(89,1,'2023-07-11 15:54:01','2023-07-11 15:54:01'),(90,1,NULL,'2024-06-14 12:40:06'),(91,1,'2022-12-30 09:02:50','2023-12-30 09:02:50'),(92,1,'2023-08-01 22:30:56','2024-08-01 22:30:56'),(93,1,'2022-10-16 06:29:52','2023-10-16 06:29:52'),(94,1,'2023-04-23 11:12:11','2024-04-23 11:12:11'),(95,1,'2023-06-02 06:41:48','2023-06-02 06:41:48'),(96,1,NULL,'2024-03-27 04:46:27'),(97,1,'2023-10-11 23:35:34','2023-10-11 23:35:34'),(98,1,'2023-03-24 08:20:46','2024-03-24 08:20:46'),(99,1,'2022-10-04 23:24:21','2023-10-04 23:24:21'),(100,1,'2022-03-27 15:43:58','2024-03-27 15:43:58'),(101,1,'2023-05-10 05:02:20','2023-05-10 05:02:20'),(103,1,'2022-08-30 14:09:29','2023-08-30 14:09:29'),(105,1,'2022-06-02 01:24:57','2023-06-02 01:24:57'),(106,1,'2023-11-19 03:14:10','2024-11-19 03:14:10'),(107,1,'2022-09-15 17:43:33','2023-09-15 17:43:33'),(108,1,NULL,'2024-05-04 16:20:10'),(109,1,'2021-12-23 00:56:41','2022-12-23 00:56:41'),(110,1,'2023-06-03 23:41:14','2024-06-03 23:41:14'),(111,1,'2021-11-19 03:26:53','2022-11-19 03:26:53'),(112,1,'2023-05-08 21:35:08','2024-05-08 21:35:08'),(113,1,'2023-04-21 19:57:32','2023-04-21 19:57:32'),(114,1,NULL,'2024-09-16 05:41:48'),(115,1,'2023-01-19 21:11:02','2023-01-19 21:11:02'),(117,1,'2023-01-06 04:25:49','2023-01-06 04:25:49'),(118,1,'2023-07-11 18:12:14','2024-07-11 18:12:14'),(119,1,'2023-10-30 03:50:53','2023-10-30 03:50:53'),(120,1,NULL,'2024-06-20 03:45:43'),(121,1,'2022-04-21 02:00:47','2023-04-21 02:00:47'),(122,1,'2021-11-02 17:22:28','2023-11-02 17:22:28'),(123,1,'2023-03-04 12:09:46','2023-03-04 12:09:46'),(124,1,'2022-05-18 00:28:17','2024-05-18 00:28:17'),(125,1,'2023-09-25 10:13:11','2023-09-25 10:13:11'),(126,1,NULL,'2024-06-15 17:36:31'),(127,1,'2022-03-03 12:34:10','2023-03-03 12:34:10'),(128,1,'2023-06-06 01:57:34','2024-06-06 01:57:34'),(129,1,'2023-05-28 09:41:13','2023-05-28 09:41:13'),(130,1,'2022-12-12 20:24:45','2024-12-12 20:24:45'),(131,1,'2023-05-22 05:13:19','2023-05-22 05:13:19'),(132,1,NULL,'2024-11-19 09:37:47'),(133,1,'2023-06-03 01:51:11','2023-06-03 01:51:11'),(135,1,'2022-07-26 20:07:46','2023-07-26 20:07:46'),(136,1,'2023-05-27 08:24:52','2024-05-27 08:24:52'),(137,1,'2023-08-12 07:21:23','2023-08-12 07:21:23'),(138,1,NULL,'2024-07-14 21:51:35'),(139,1,'2023-04-15 12:23:54','2023-04-15 12:23:54'),(140,1,'2023-03-24 07:28:52','2024-03-24 07:28:52'),(141,1,'2021-11-02 23:30:02','2022-11-02 23:30:02'),(142,1,'2022-03-12 00:26:06','2024-03-12 00:26:06'),(143,1,'2023-10-05 13:21:38','2023-10-05 13:21:38'),(144,1,NULL,'2024-12-24 05:23:32'),(145,1,'2023-08-22 05:59:40','2023-08-22 05:59:40'),(146,1,'2022-09-27 11:45:02','2024-09-27 11:45:02'),(147,1,'2022-03-21 04:34:51','2023-03-21 04:34:51'),(148,1,'2021-11-05 08:45:31','2023-11-05 08:45:31'),(149,1,'2023-02-16 13:08:29','2023-02-16 13:08:29'),(150,1,NULL,'2024-12-22 07:29:07'),(151,1,'2021-12-04 09:31:43','2022-12-04 09:31:43'),(152,1,'2023-05-14 16:17:37','2024-05-14 16:17:37'),(153,1,'2023-03-01 14:11:30','2023-03-01 14:11:30'),(154,1,'2022-11-29 14:31:17','2024-11-29 14:31:17'),(155,1,'2022-03-01 17:09:37','2023-03-01 17:09:37'),(156,1,NULL,'2024-08-08 14:31:15'),(157,1,'2022-10-08 02:21:48','2023-10-08 02:21:48'),(158,1,'2022-09-29 08:13:27','2024-09-29 08:13:27'),(159,1,'2023-10-31 19:54:54','2023-10-31 19:54:54'),(161,1,'2023-03-25 20:59:47','2023-03-25 20:59:47'),(162,1,NULL,'2024-06-18 06:15:03'),(163,1,'2023-04-23 23:06:54','2023-04-23 23:06:54'),(164,1,'2023-07-17 17:20:35','2024-07-17 17:20:35'),(165,1,'2022-02-08 22:30:01','2023-02-08 22:30:01'),(167,1,'2022-02-12 14:52:26','2023-02-12 14:52:26'),(168,1,NULL,'2024-08-01 17:50:57'),(169,1,'2023-11-15 10:44:42','2023-11-15 10:44:42'),(170,1,'2022-02-17 17:54:37','2024-02-17 17:54:37'),(171,1,'2022-08-25 20:46:18','2023-08-25 20:46:18'),(172,1,'2022-02-07 14:30:32','2024-02-07 14:30:32'),(173,1,'2023-01-04 22:19:21','2023-01-04 22:19:21'),(174,1,NULL,'2024-01-05 03:43:31'),(175,1,'2023-07-26 02:51:34','2023-07-26 02:51:34'),(176,1,'2023-01-09 05:42:00','2024-01-09 05:42:00'),(177,1,'2022-11-02 13:13:29','2023-11-02 13:13:29'),(178,1,'2023-06-05 17:35:57','2024-06-05 17:35:57'),(179,1,'2023-10-11 16:05:21','2023-10-11 16:05:21'),(180,1,NULL,'2024-06-24 00:14:12'),(181,1,'2022-05-27 14:43:00','2023-05-27 14:43:00'),(182,1,'2023-04-12 20:48:50','2024-04-12 20:48:50'),(183,1,'2023-03-10 01:03:41','2023-03-10 01:03:41'),(184,1,'2023-07-10 06:25:41','2024-07-10 06:25:41'),(185,1,'2023-06-11 18:12:30','2023-06-11 18:12:30'),(186,1,NULL,'2024-03-16 01:34:39'),(187,1,'2022-06-10 02:33:38','2023-06-10 02:33:38'),(188,1,'2022-01-19 03:39:12','2024-01-19 03:39:12'),(189,1,'2022-03-21 13:54:47','2023-03-21 13:54:47'),(190,1,'2022-06-14 12:40:06','2024-06-24 00:14:12'),(191,1,'2022-12-30 09:02:50','2023-01-09 05:42:00'),(192,1,NULL,'2024-11-02 13:13:29'),(193,1,'2022-10-16 06:29:52','2023-06-05 17:35:57'),(194,1,'2023-04-23 11:12:11','2024-10-11 16:05:21'),(195,1,'2023-06-02 06:41:48','2023-06-03 15:57:53'),(196,1,'2023-03-27 04:46:27','2024-05-27 14:43:00'),(197,1,'2023-10-11 23:35:34','2023-04-12 20:48:50'),(198,1,NULL,'2024-03-10 01:03:41'),(199,1,'2022-10-04 23:24:21','2023-04-12 20:48:50'),(200,1,'2022-03-27 15:43:58','2024-03-10 01:03:41');
/*!40000 ALTER TABLE `pistas_abiertas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pistas_cerradas`
--

DROP TABLE IF EXISTS `pistas_cerradas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pistas_cerradas` (
  `id_pista` int(10) NOT NULL,
  `fecha_clausura` date NOT NULL,
  `motivo` varchar(500) NOT NULL,
  PRIMARY KEY (`id_pista`),
  KEY `id_pista` (`id_pista`),
  CONSTRAINT `pistas_cerradas_ibfk_1` FOREIGN KEY (`id_pista`) REFERENCES `pistas` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pistas_cerradas`
--

LOCK TABLES `pistas_cerradas` WRITE;
/*!40000 ALTER TABLE `pistas_cerradas` DISABLE KEYS */;
INSERT INTO `pistas_cerradas` VALUES (20,'2021-01-01','Se ha roto'),(21,'2023-04-06','Defectuosa'),(22,'2022-03-05','Se ha roto'),(23,'2023-04-05','Se ha roto'),(24,'2023-06-05','Se ha roto'),(25,'2022-07-05','Se ha roto');
/*!40000 ALTER TABLE `pistas_cerradas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `polideportivos`
--

DROP TABLE IF EXISTS `polideportivos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `polideportivos` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(50) NOT NULL,
  `direccion` varchar(50) DEFAULT NULL,
  `ciudad` varchar(255) NOT NULL,
  `extension` float DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `nombre` (`nombre`)
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `polideportivos`
--

LOCK TABLES `polideportivos` WRITE;
/*!40000 ALTER TABLE `polideportivos` DISABLE KEYS */;
INSERT INTO `polideportivos` VALUES (1,'BR','P.O. Box 215, 5931 Pellentesque Road','Zamora',289),(2,'NA','Ap #934-3170 Fusce Rd.','Salamanca',192),(3,'British Columbia','P.O. Box 485, 5090 Elit. Road','Leon',480),(4,'Brandenburg','929-2153 Varius Road','Leon',259),(5,'San José','803-9134 Odio. Rd.','Bembibre',361),(6,'Brd','145-2997 Ultrices Ave','Leon',399),(7,'Idaho',NULL,'Ponferrada',231),(8,'SP','P.O. Box 416, 2887 Vulputate, Avenue','Bembibre',415),(9,'AC','Ap #925-8557 Eu, Street','Leon',235),(10,'SI','Ap #509-7693 Dapibus Street','Burgos',323),(11,'TA','451-4958 Amet Rd.','Bembibre',479),(12,'Western Australia','Ap #409-6570 Curabitur Road','Leon',213),(13,'NI','P.O. Box 167, 2006 Risus Rd.','Palencia',383),(14,'Connecticut',NULL,'Ponferrada',152),(15,'Provence-Alpes-Côte d\'Azur','5132 Mi St.','Leon',397),(16,'Yukon','P.O. Box 947, 1703 Curabitur St.','Segovia',296),(17,'Nova Scotia','326-4329 Ac Av.','Burgos',411),(18,'Vienna','694-7588 Ornare. Av.','Leon',206),(19,'La','P.O. Box 162, 7033 Habitant Rd.','Palencia',271),(20,'BA','P.O. Box 878, 3169 Justo St.','Salamanca',172),(21,'Cartago',NULL,'Ponferrada',195),(22,'Morayshire','P.O. Box 585, 3356 Ipsum. Rd.','Salamanca',207),(23,'Louisiana','124-2101 Pede, Rd.','Avila',106),(24,'ES','207-6873 Id Road','Leon',479),(25,'Franche-Comté','7460 Consectetuer St.','Palencia',120),(26,'Noord Brabant','P.O. Box 473, 8577 Neque. St.','Valladolid',354),(27,'CA','649-1999 Nullam St.','Leon',367),(28,'Minnesota',NULL,'Ponferrada',348),(29,'Heredia','6419 Nec Road','Zamora',338),(30,'BY','5256 Et Av.','Leon',278),(31,'SF','724-1228 Lacus Ave','Zamora',124),(32,'Manitoba','862-3322 Amet, Road','Burgos',353),(33,'Reino de León','324-4565, Papalaguinda','Leon',678);
/*!40000 ALTER TABLE `polideportivos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reservas`
--

DROP TABLE IF EXISTS `reservas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `reservas` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `fecha_reserva` timestamp NOT NULL DEFAULT current_timestamp(),
  `fecha_uso` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `precio` float DEFAULT 0,
  `id_pista` int(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_pista` (`id_pista`),
  CONSTRAINT `reservas_ibfk_1` FOREIGN KEY (`id_pista`) REFERENCES `pistas` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=201 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reservas`
--

LOCK TABLES `reservas` WRITE;
/*!40000 ALTER TABLE `reservas` DISABLE KEYS */;
INSERT INTO `reservas` VALUES (1,'2020-10-08 05:22:46','2020-10-11 05:22:46',7,199),(2,'2020-01-04 11:00:23','2020-01-10 11:00:23',8,41),(3,'2020-07-16 10:02:48','2020-07-25 10:02:48',8,148),(4,'2021-02-10 22:19:44','2021-02-22 22:19:44',8,175),(5,'2021-11-16 23:42:51','2021-12-01 23:42:51',7,199),(6,'2021-11-06 21:23:25','2021-11-24 21:23:25',9,86),(7,'2020-10-24 12:46:27','2020-11-14 13:46:27',10,138),(8,'2021-03-13 19:25:02','2021-04-06 18:25:02',5,146),(9,'2020-11-10 16:33:40','2020-12-07 16:33:40',8,87),(10,'2020-06-23 11:14:57','2020-07-23 11:14:57',9,149),(11,'2020-02-18 07:03:52','2020-03-22 07:03:52',7,39),(12,'2021-04-30 00:16:46','2021-06-05 00:16:46',8,110),(13,'2021-10-16 06:31:55','2021-11-24 07:31:55',9,178),(14,'2021-05-18 02:34:21','2021-06-29 02:34:21',9,114),(15,'2021-10-25 12:19:56','2021-12-09 13:19:56',5,28),(16,'2020-05-10 07:04:26','2020-06-27 07:04:26',8,89),(17,'2021-03-21 16:55:12','2021-05-11 15:55:12',7,110),(18,'2020-01-25 20:57:34','2020-03-19 20:57:34',6,136),(19,'2020-01-22 02:56:39','2020-03-19 02:56:39',5,122),(20,'2020-12-14 02:17:45','2021-02-12 02:17:45',7,40),(21,'2021-06-26 08:24:06','2021-08-28 08:24:06',7,106),(22,'2020-03-31 15:59:04','2020-06-05 15:59:04',5,95),(23,'2021-11-14 17:44:44','2022-01-22 17:44:44',8,176),(24,'2020-03-26 07:05:00','2020-06-06 06:05:00',8,15),(25,'2020-07-28 08:29:29','2020-10-11 08:29:29',7,4),(26,'2021-09-20 13:54:24','2021-12-07 14:54:24',7,197),(27,'2021-11-10 04:21:36','2022-01-30 04:21:36',9,161),(28,'2021-04-10 02:45:55','2021-07-03 02:45:55',7,175),(29,'2020-04-09 11:07:30','2020-07-05 11:07:30',5,1),(30,'2021-03-10 22:35:16','2021-06-08 21:35:16',7,186),(31,'2021-07-30 06:14:53','2021-10-31 07:14:53',10,118),(32,'2021-02-19 10:52:44','2021-05-26 09:52:44',6,62),(33,'2021-09-06 17:33:55','2021-12-14 18:33:55',6,121),(34,'2021-12-03 05:38:27','2022-03-15 05:38:27',6,65),(35,'2020-08-14 15:00:01','2020-11-27 16:00:01',10,21),(36,'2021-08-10 13:27:12','2021-11-26 14:27:12',6,73),(37,'2021-02-18 16:18:49','2021-06-09 15:18:49',10,179),(38,'2021-12-25 09:43:18','2022-04-18 08:43:18',7,84),(39,'2020-05-30 01:51:10','2020-09-24 01:51:10',6,32),(40,'2021-05-24 05:51:02','2021-09-21 05:51:02',7,33),(41,'2021-04-30 14:41:38','2021-08-31 14:41:38',10,37),(42,'2021-03-23 10:07:55','2021-07-27 09:07:55',5,133),(43,'2021-11-14 20:42:04','2022-03-23 20:42:04',7,184),(44,'2021-04-24 02:20:15','2021-09-03 02:20:15',7,169),(45,'2021-01-29 08:26:42','2021-06-13 07:26:42',7,188),(46,'2021-09-19 03:40:45','2022-02-04 04:40:45',10,43),(47,'2020-11-18 22:11:18','2021-04-08 21:11:18',5,149),(48,'2021-10-31 19:56:59','2022-03-24 19:56:59',8,81),(49,'2020-02-28 20:46:28','2020-07-24 19:46:28',10,22),(50,'2020-08-02 05:00:20','2020-12-30 06:00:20',5,53),(51,'2020-02-06 06:23:30','2020-07-08 05:23:30',9,89),(52,'2020-05-05 13:40:19','2020-10-08 13:40:19',5,139),(53,'2021-01-29 05:18:03','2021-07-07 04:18:03',5,186),(54,'2021-11-18 01:19:40','2022-04-29 00:19:40',9,94),(55,'2021-02-19 06:42:31','2021-08-03 05:42:31',8,18),(56,'2021-09-22 14:33:24','2022-03-09 15:33:24',9,65),(57,'2021-09-26 04:17:41','2022-03-16 05:17:41',9,24),(58,'2021-11-10 11:03:10','2022-05-03 10:03:10',5,28),(59,'2021-09-09 14:45:33','2022-03-05 15:45:33',8,126),(60,'2021-10-22 06:51:26','2022-04-20 06:51:26',7,199),(61,'2021-04-27 05:10:49','2021-10-27 05:10:49',6,31),(62,'2020-09-25 16:30:09','2021-03-30 16:30:09',10,159),(63,'2021-04-28 23:48:05','2021-11-04 00:48:05',9,111),(64,'2020-06-04 23:35:41','2020-12-14 00:35:41',5,183),(65,'2020-02-18 22:32:31','2020-08-31 21:32:31',8,154),(66,'2020-01-22 16:49:31','2020-08-07 15:49:31',9,72),(67,'2021-06-12 21:53:05','2021-12-30 22:53:05',6,88),(68,'2020-04-11 06:31:56','2020-11-01 07:31:56',9,58),(69,'2021-09-18 12:16:22','2022-04-13 12:16:22',7,106),(70,'2020-09-18 03:51:20','2021-04-16 03:51:20',6,86),(71,'2021-12-20 18:47:09','2022-07-21 17:47:09',8,114),(72,'2020-03-20 16:00:42','2020-10-22 15:00:42',7,128),(73,'2021-08-22 04:40:31','2022-03-29 04:40:31',10,59),(74,'2020-12-20 04:50:31','2021-07-30 03:50:31',6,68),(75,'2021-07-31 21:42:35','2022-03-13 22:42:35',7,65),(76,'2021-12-16 09:35:54','2022-08-01 08:35:54',9,45),(77,'2021-02-02 15:02:38','2021-09-21 14:02:38',6,29),(78,'2021-07-04 04:04:26','2022-02-23 05:04:26',10,117),(79,'2021-02-16 23:04:14','2021-10-11 22:04:14',7,142),(80,'2020-02-09 20:42:08','2020-10-06 19:42:08',6,126),(81,'2021-04-20 23:08:34','2021-12-20 00:08:34',7,91),(82,'2021-09-20 10:53:59','2022-05-24 10:53:59',6,115),(83,'2021-01-14 11:08:56','2021-09-20 10:08:56',8,58),(84,'2021-08-09 04:35:22','2022-04-18 04:35:22',9,15),(85,'2021-09-21 09:17:21','2022-06-03 09:17:21',5,12),(86,'2021-07-27 11:25:36','2022-04-11 11:25:36',6,15),(87,'2021-09-17 08:30:21','2022-06-05 08:30:21',8,182),(88,'2021-06-21 12:28:40','2022-03-12 13:28:40',7,108),(89,'2020-03-18 14:00:25','2020-12-10 14:00:25',6,156),(90,'2021-03-06 02:41:59','2021-12-01 02:41:59',8,85),(91,'2021-06-27 06:39:47','2022-03-27 06:39:47',6,168),(92,'2020-05-25 20:14:09','2021-02-25 21:14:09',10,180),(93,'2021-10-26 10:37:47','2022-08-01 10:37:47',9,52),(94,'2020-07-18 02:20:21','2021-04-26 02:20:21',8,141),(95,'2021-01-22 17:57:39','2021-11-03 17:57:39',8,163),(96,'2020-01-09 11:49:55','2020-10-23 10:49:55',8,191),(97,'2021-09-12 03:10:14','2022-06-30 03:10:14',5,26),(98,'2020-02-24 19:30:32','2020-12-14 19:30:32',7,66),(99,'2021-09-21 00:40:24','2022-07-15 00:40:24',10,137),(100,'2021-11-26 23:05:45','2022-09-22 22:05:45',9,37),(101,'2020-10-08 05:22:46','2021-08-07 05:22:46',7,101),(102,'2020-01-04 11:00:23','2020-11-05 11:00:23',9,198),(103,'2020-07-16 10:02:48','2021-05-21 10:02:48',8,20),(104,'2021-02-10 22:19:44','2021-12-19 22:19:44',9,114),(105,'2021-11-16 23:42:51','2022-09-27 22:42:51',6,140),(106,'2021-11-06 21:23:25','2022-09-20 20:23:25',5,27),(107,'2020-10-24 12:46:27','2021-09-10 12:46:27',8,47),(108,'2021-03-13 19:25:02','2022-01-31 19:25:02',9,98),(109,'2020-11-10 16:33:40','2021-10-03 15:33:40',5,138),(110,'2020-06-23 11:14:57','2021-05-19 11:14:57',10,139),(111,'2020-02-18 07:03:52','2021-01-16 07:03:52',5,16),(112,'2021-04-30 00:16:46','2022-04-01 00:16:46',9,200),(113,'2021-10-16 06:31:55','2022-09-20 06:31:55',8,169),(114,'2021-05-18 02:34:21','2022-04-25 02:34:21',8,17),(115,'2021-10-25 12:19:56','2022-10-05 12:19:56',9,107),(116,'2020-05-10 07:04:26','2021-04-23 07:04:26',6,196),(117,'2021-03-21 16:55:12','2022-03-07 16:55:12',10,194),(118,'2020-01-25 20:57:34','2021-01-13 20:57:34',8,133),(119,'2020-01-22 02:56:39','2021-01-13 02:56:39',5,122),(120,'2020-12-14 02:17:45','2021-12-09 02:17:45',9,5),(121,'2021-06-26 08:24:06','2022-06-24 08:24:06',5,178),(122,'2020-03-31 15:59:04','2021-04-01 15:59:04',9,191),(123,'2021-11-14 17:44:44','2022-11-18 17:44:44',6,167),(124,'2020-03-26 07:05:00','2021-04-02 06:05:00',6,9),(125,'2020-07-28 08:29:29','2021-08-07 08:29:29',7,12),(126,'2021-09-20 13:54:24','2022-10-03 13:54:24',10,129),(127,'2021-11-10 04:21:36','2022-11-26 04:21:36',7,96),(128,'2021-04-10 02:45:55','2022-04-29 02:45:55',8,60),(129,'2020-04-09 11:07:30','2021-05-01 11:07:30',5,71),(130,'2021-03-10 22:35:16','2022-04-04 21:35:16',7,154),(131,'2021-07-30 06:14:53','2022-08-27 06:14:53',5,121),(132,'2021-02-19 10:52:44','2022-03-22 10:52:44',7,88),(133,'2021-09-06 17:33:55','2022-10-10 17:33:55',10,26),(134,'2021-12-03 05:38:27','2023-01-09 05:38:27',10,193),(135,'2020-08-14 15:00:01','2021-09-23 15:00:01',7,186),(136,'2021-08-10 13:27:12','2022-09-22 13:27:12',9,96),(137,'2021-02-18 16:18:49','2022-04-05 15:18:49',9,150),(138,'2021-12-25 09:43:18','2023-02-12 09:43:18',6,103),(139,'2020-05-30 01:51:10','2021-07-21 01:51:10',10,189),(140,'2021-05-24 05:51:02','2022-07-18 05:51:02',5,56),(141,'2021-04-30 14:41:38','2022-06-27 14:41:38',5,31),(142,'2021-03-23 10:07:55','2022-05-23 09:07:55',7,58),(143,'2021-11-14 20:42:04','2023-01-17 20:42:04',5,156),(144,'2021-04-24 02:20:15','2022-06-30 02:20:15',10,69),(145,'2021-01-29 08:26:42','2022-04-09 07:26:42',8,172),(146,'2021-09-19 03:40:45','2022-12-01 04:40:45',5,198),(147,'2020-11-18 22:11:18','2022-02-02 22:11:18',5,137),(148,'2021-10-31 19:56:59','2023-01-18 19:56:59',10,61),(149,'2020-02-28 20:46:28','2021-05-20 19:46:28',10,67),(150,'2020-08-02 05:00:20','2021-10-26 05:00:20',9,155),(151,'2020-02-06 06:23:30','2021-05-04 05:23:30',9,111),(152,'2020-05-05 13:40:19','2021-08-04 13:40:19',8,121),(153,'2021-01-29 05:18:03','2022-05-03 04:18:03',6,122),(154,'2021-11-18 01:19:40','2023-02-23 01:19:40',6,73),(155,'2021-02-19 06:42:31','2022-05-30 05:42:31',5,150),(156,'2021-09-22 14:33:24','2023-01-03 15:33:24',10,133),(157,'2021-09-26 04:17:41','2023-01-10 05:17:41',7,34),(158,'2021-11-10 11:03:10','2023-02-27 11:03:10',5,45),(159,'2021-09-09 14:45:33','2022-12-30 15:45:33',10,51),(160,'2021-10-22 06:51:26','2023-02-14 07:51:26',5,172),(161,'2021-04-27 05:10:49','2022-08-23 05:10:49',5,145),(162,'2020-09-25 16:30:09','2022-01-24 17:30:09',8,157),(163,'2021-04-28 23:48:05','2022-08-30 23:48:05',8,69),(164,'2020-06-04 23:35:41','2021-10-09 23:35:41',8,132),(165,'2020-02-18 22:32:31','2021-06-27 21:32:31',10,199),(166,'2020-01-22 16:49:31','2021-06-03 15:49:31',8,150),(167,'2021-06-12 21:53:05','2022-10-26 21:53:05',5,148),(168,'2020-04-11 06:31:56','2021-08-28 06:31:56',9,167),(169,'2021-09-18 12:16:22','2023-02-07 13:16:22',5,59),(170,'2020-09-18 03:51:20','2022-02-10 04:51:20',7,84),(171,'2021-12-20 18:47:09','2023-05-17 17:47:09',5,129),(172,'2020-03-20 16:00:42','2021-08-18 15:00:42',10,150),(173,'2021-08-22 04:40:31','2023-01-23 05:40:31',8,96),(174,'2020-12-20 04:50:31','2022-05-26 03:50:31',5,74),(175,'2021-07-31 21:42:35','2023-01-07 22:42:35',9,158),(176,'2021-12-16 09:35:54','2023-05-28 08:35:54',6,92),(177,'2021-02-02 15:02:38','2022-07-18 14:02:38',5,113),(178,'2021-07-04 04:04:26','2022-12-20 05:04:26',6,168),(179,'2021-02-16 23:04:14','2022-08-07 22:04:14',10,146),(180,'2020-02-09 20:42:08','2021-08-02 19:42:08',9,157),(181,'2021-04-20 23:08:34','2022-10-15 23:08:34',5,34),(182,'2021-09-20 10:53:59','2023-03-20 11:53:59',7,83),(183,'2021-01-14 11:08:56','2022-07-17 10:08:56',10,162),(184,'2021-08-09 04:35:22','2023-02-12 05:35:22',10,185),(185,'2021-09-21 09:17:21','2023-03-30 09:17:21',9,179),(186,'2021-07-27 11:25:36','2023-02-05 12:25:36',10,78),(187,'2021-09-17 08:30:21','2023-04-01 08:30:21',7,143),(188,'2021-06-21 12:28:40','2023-01-06 13:28:40',8,98),(189,'2020-03-18 14:00:25','2021-10-06 13:00:25',10,2),(190,'2021-03-06 02:41:59','2022-09-27 01:41:59',10,164),(191,'2021-06-27 06:39:47','2023-01-21 07:39:47',8,159),(192,'2020-05-25 20:14:09','2021-12-22 21:14:09',8,40),(193,'2021-10-26 10:37:47','2023-05-28 10:37:47',9,32),(194,'2020-07-18 02:20:21','2022-02-20 03:20:21',5,60),(195,'2021-01-22 17:57:39','2022-08-30 16:57:39',8,57),(196,'2020-01-09 11:49:55','2021-08-19 10:49:55',9,131),(197,'2021-09-12 03:10:14','2023-04-26 03:10:14',5,135),(198,'2020-02-24 19:30:32','2021-10-10 18:30:32',8,191),(199,'2021-09-21 00:40:24','2023-05-11 00:40:24',5,2),(200,'2020-01-09 11:49:55','2021-08-31 10:49:55',6,149);
/*!40000 ALTER TABLE `reservas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `servicios_polideportivo`
--

DROP TABLE IF EXISTS `servicios_polideportivo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `servicios_polideportivo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `servicio` varchar(50) NOT NULL,
  `id_polideportivo` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_polideportivo` (`id_polideportivo`),
  CONSTRAINT `servicios_polideportivo_ibfk_1` FOREIGN KEY (`id_polideportivo`) REFERENCES `polideportivos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=101 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `servicios_polideportivo`
--

LOCK TABLES `servicios_polideportivo` WRITE;
/*!40000 ALTER TABLE `servicios_polideportivo` DISABLE KEYS */;
INSERT INTO `servicios_polideportivo` VALUES (1,'Movies',4),(2,'Industrial',20),(3,'Clothing',28),(4,'Toys',11),(5,'Tools',11),(6,'Baby',5),(7,'Garden',28),(8,'Tools',14),(9,'Shoes',2),(10,'Sports',12),(11,'Grocery',7),(12,'Computers',26),(13,'Music',15),(14,'Tools',7),(15,'Computers',17),(16,'Health',31),(17,'Automotive',14),(18,'Jewelry',15),(19,'Automotive',7),(20,'Baby',4),(21,'Clothing',12),(22,'Kids',11),(23,'Electronics',12),(24,'Movies',12),(25,'Grocery',15),(26,'Toys',1),(27,'Grocery',31),(28,'Computers',33),(29,'Clothing',13),(30,'Music',8),(31,'Beauty',30),(32,'Computers',32),(33,'Industrial',33),(34,'Toys',21),(35,'Books',9),(36,'Electronics',13),(37,'Home',20),(38,'Toys',31),(39,'Computers',32),(40,'Books',13),(41,'Home',10),(42,'Baby',8),(43,'Health',16),(44,'Baby',10),(45,'Games',17),(46,'Beauty',17),(47,'Books',3),(48,'Games',28),(49,'Music',33),(50,'Games',31),(51,'Games',22),(52,'Games',14),(53,'Games',16),(54,'Home',27),(55,'Clothing',14),(56,'Garden',17),(57,'Sports',8),(58,'Baby',30),(59,'Automotive',17),(60,'Health',24),(61,'Grocery',25),(62,'Beauty',6),(63,'Beauty',32),(64,'Toys',17),(65,'Tools',16),(66,'Beauty',17),(67,'Clothing',29),(68,'Clothing',32),(69,'Computers',8),(70,'Clothing',23),(71,'Tools',14),(72,'Health',29),(73,'Computers',20),(74,'Music',15),(75,'Music',26),(76,'Garden',27),(77,'Health',9),(78,'Books',25),(79,'Computers',14),(80,'Sports',24),(81,'Health',28),(82,'Industrial',2),(83,'Electronics',12),(84,'Electronics',11),(85,'Shoes',28),(86,'Clothing',17),(87,'Games',6),(88,'Grocery',23),(89,'Sports',25),(90,'Electronics',6),(91,'Shoes',2),(92,'Kids',15),(93,'Computers',25),(94,'Clothing',12),(95,'Computers',30),(96,'Outdoors',33),(97,'Automotive',3),(98,'Industrial',16),(99,'Baby',26),(100,'Home',15);
/*!40000 ALTER TABLE `servicios_polideportivo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `usuario_reserva`
--

DROP TABLE IF EXISTS `usuario_reserva`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `usuario_reserva` (
  `id_usuario` int(10) NOT NULL DEFAULT 0,
  `id_reserva` int(10) NOT NULL DEFAULT 0,
  `asiste` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id_usuario`,`id_reserva`),
  KEY `id_usuario` (`id_usuario`),
  KEY `id_reserva` (`id_reserva`),
  CONSTRAINT `usuario_reserva_ibfk_1` FOREIGN KEY (`id_usuario`) REFERENCES `usuarios` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `usuario_reserva_ibfk_2` FOREIGN KEY (`id_reserva`) REFERENCES `reservas` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `usuario_reserva`
--

LOCK TABLES `usuario_reserva` WRITE;
/*!40000 ALTER TABLE `usuario_reserva` DISABLE KEYS */;
INSERT INTO `usuario_reserva` VALUES (1,6,0),(1,46,0),(1,54,0),(1,120,0),(2,34,1),(2,157,1),(3,98,0),(3,99,0),(4,48,1),(4,79,1),(4,190,1),(5,10,0),(5,20,0),(5,34,0),(5,71,0),(5,87,0),(5,105,0),(5,171,0),(6,11,1),(6,124,1),(6,137,1),(6,179,1),(6,189,1),(8,114,1),(8,174,1),(9,3,0),(9,14,0),(9,43,0),(9,91,0),(9,109,0),(9,149,0),(10,8,1),(10,108,1),(11,9,0),(11,16,0),(11,29,0),(11,112,0),(12,13,1),(12,17,1),(12,101,1),(12,164,1),(13,93,0),(13,104,0),(13,162,0),(14,19,1),(14,110,1),(14,118,1),(14,129,1),(15,25,0),(15,34,0),(15,39,0),(15,59,0),(16,21,1),(16,60,1),(17,77,0),(17,179,0),(18,42,1),(18,155,1),(19,119,0),(19,197,0),(20,18,1),(20,34,1),(20,140,1),(20,185,1),(21,15,0),(21,26,0),(21,57,0),(21,118,0),(21,121,0),(21,145,0),(21,164,0),(21,166,0),(22,6,1),(23,20,0),(23,28,0),(23,51,0),(23,65,0),(23,94,0),(23,104,0),(23,170,0),(24,33,1),(24,49,1),(24,64,1),(24,96,1),(24,147,1),(25,27,0),(25,31,0),(25,33,0),(26,91,1),(26,115,1),(26,126,1),(26,147,1),(26,182,1),(27,25,0),(27,127,0),(27,175,0),(27,180,0),(28,52,1),(28,128,1),(28,147,1),(28,162,1),(28,171,1),(29,62,0),(29,70,0),(29,72,0),(29,113,0),(30,35,1),(30,104,1),(30,130,1),(30,134,1),(31,123,0),(31,138,0),(32,46,1),(32,86,1),(32,153,1),(32,156,1),(33,38,0),(33,133,0),(34,13,1),(34,54,1),(34,58,1),(35,37,0),(35,135,0),(36,29,1),(36,125,1),(36,136,1),(37,101,0),(37,139,0),(37,173,0),(39,44,0),(39,183,0),(42,147,1),(42,153,1),(42,187,1),(42,196,1),(42,197,1),(44,101,1),(44,111,1),(44,144,1),(45,50,0),(46,69,1),(46,124,1),(46,132,1),(46,146,1),(47,81,0),(47,108,0),(47,111,0),(47,125,0),(47,143,0),(48,94,1),(49,18,0),(49,47,0),(49,48,0),(49,86,0),(50,23,1),(50,55,1),(50,150,1),(54,6,1),(54,97,1),(54,113,1),(54,154,1),(54,176,1),(54,192,1),(55,7,0),(55,46,0),(55,155,0),(55,172,0),(56,63,1),(56,134,1),(57,29,0),(57,151,0),(57,160,0),(58,22,1),(58,69,1),(58,94,1),(59,43,0),(59,67,0),(59,84,0),(59,108,0),(59,115,0),(59,117,0),(59,159,0),(60,48,1),(60,49,1),(60,99,1),(61,77,0),(61,113,0),(61,118,0),(61,158,0),(62,174,1),(63,5,0),(63,68,0),(63,156,0),(63,163,0),(64,12,1),(64,58,1),(65,63,0),(65,165,0),(66,15,1),(66,54,1),(66,72,1),(66,106,1),(67,74,0),(67,90,0),(67,161,0),(68,73,1),(68,104,1),(68,129,1),(68,168,1),(69,77,0),(69,169,0),(70,117,1),(70,180,1),(71,76,0),(71,99,0),(71,176,0),(71,180,0),(72,53,1),(72,134,1),(72,172,1),(73,36,0),(73,37,0),(73,75,0),(73,78,0),(73,83,0),(74,30,1),(74,131,1),(74,151,1),(74,164,1),(75,80,0),(75,148,0),(76,77,1),(77,61,0),(77,82,0),(77,174,0),(77,177,0),(78,97,1),(78,115,1),(79,39,0),(79,113,0),(79,167,0),(80,45,1),(80,142,1),(80,173,1),(81,181,0),(81,197,0),(82,123,1),(82,156,1),(82,157,1),(82,171,1),(82,182,1),(83,47,0),(83,95,0),(83,104,0),(83,120,0),(83,141,0),(83,175,0),(83,189,0),(84,52,1),(84,72,1),(84,88,1),(84,89,1),(84,132,1),(84,184,1),(85,102,0),(85,138,0),(85,148,0),(87,32,0),(87,92,0),(87,182,0),(87,197,0),(89,52,0),(89,122,0),(89,178,0),(90,134,1),(90,155,1),(91,36,0),(91,53,0),(91,103,0),(91,191,0),(91,194,0),(92,45,1),(92,161,1),(93,24,0),(93,32,0),(93,42,0),(93,62,0),(93,193,0),(93,198,0),(94,75,1),(94,116,1),(94,186,1),(94,188,1),(95,97,0),(95,100,0),(95,190,0),(95,195,0),(96,20,1),(97,1,0),(97,3,0),(97,60,0),(97,64,0),(98,57,1),(98,192,1),(99,4,0),(99,192,0),(99,199,0),(100,7,1),(100,200,1);
/*!40000 ALTER TABLE `usuario_reserva` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `usuario_usuario`
--

DROP TABLE IF EXISTS `usuario_usuario`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `usuario_usuario` (
  `id_usuario` int(10) NOT NULL,
  `id_amigo` int(10) NOT NULL,
  PRIMARY KEY (`id_usuario`,`id_amigo`),
  KEY `id_amigo` (`id_amigo`),
  CONSTRAINT `usuario_usuario_ibfk_1` FOREIGN KEY (`id_usuario`) REFERENCES `usuarios` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION,
  CONSTRAINT `usuario_usuario_ibfk_2` FOREIGN KEY (`id_amigo`) REFERENCES `usuarios` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `usuario_usuario`
--

LOCK TABLES `usuario_usuario` WRITE;
/*!40000 ALTER TABLE `usuario_usuario` DISABLE KEYS */;
INSERT INTO `usuario_usuario` VALUES (1,2),(1,5),(1,8),(2,3),(2,9),(3,8),(3,10),(3,15),(3,17),(4,5),(4,7),(4,11),(5,6),(5,12),(6,13),(7,8),(7,14),(8,15),(9,16),(10,17),(11,18),(12,19),(13,20),(14,21),(15,22),(16,23),(17,24),(18,25),(19,26),(20,27),(21,28),(22,29),(23,30),(24,31),(25,32),(26,33),(27,34),(28,35),(29,36),(30,37),(42,49),(43,50),(44,51),(45,52),(46,53),(47,54),(48,55),(49,56);
/*!40000 ALTER TABLE `usuario_usuario` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `usuarios`
--

DROP TABLE IF EXISTS `usuarios`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `usuarios` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `dni` char(9) NOT NULL,
  `nombre` varchar(50) NOT NULL,
  `apellidos` varchar(50) NOT NULL,
  `email` varchar(50) DEFAULT NULL,
  `ciudad` varchar(255) NOT NULL,
  `fecha_nacimiento` date DEFAULT NULL,
  `descuento` float DEFAULT 0,
  `fecha_alta` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `dni` (`dni`),
  UNIQUE KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=101 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `usuarios`
--

LOCK TABLES `usuarios` WRITE;
/*!40000 ALTER TABLE `usuarios` DISABLE KEYS */;
INSERT INTO `usuarios` VALUES (1,'WFPHMYMZ7','Medge','Franklin','purus.Maecenas.libero@inhendreritconsectetuer.edu','Ponferrada','2005-06-25',0.1,'2018-03-22'),(2,'IWFFOBHP1','Jin','Mcleod','nunc.risus.varius@conubianostraper.net','Zamora','1995-11-11',0.1,'2018-06-18'),(3,'KOOOQQRH3','Kadeem','Palmer','ac.risus.Morbi@sedpede.co.uk','Leon','1992-09-07',0.15,'2019-02-23'),(4,'AIXZNVWS0','Fletcher','Knox','nunc@atortor.ca','Ponferrada','1981-08-20',0.17,'2019-03-21'),(5,'YTZRLZHO3','Ima','Beard','vel@Namporttitorscelerisque.org','Salamanca','2001-03-08',0.45,'2018-12-03'),(6,'LKFQCZQN3','Kane','Roth','et.nunc@sagittisfelis.ca','Leon','1986-06-06',0.1,'2019-12-20'),(7,'QJWQZQHJ9','Barry','Todd','magna.Lorem@Phasellus.edu','Palencia','1994-07-22',NULL,'2018-01-24'),(8,'TFXGIFSY2','Adam','Bryan','Donec@egetodioAliquam.com','Zamora','2004-12-30',0.1,'2020-03-25'),(9,'BAEXODHD3','Mechelle','Moran','consequat.purus@sit.edu','Leon','1994-10-11',0.1,'2018-06-04'),(10,'WRDQJRTW6','Brock','Obrien','tincidunt.aliquam.arcu@eget.co.uk','Salamanca','1983-02-23',0.1,'2020-08-29'),(11,'TPBHNPJJ3','Charissa','Stout','luctus.sit.amet@volutpatNulladignissim.ca','Burgos','2004-11-10',0.1,'2019-03-18'),(12,'JQMDWBEK8','Sybil','Barnett','neque.sed.sem@Fuscefeugiat.edu','Leon','1998-08-04',0.1,'2020-03-20'),(13,'SSDKCIPH4','Abel','Rios','Donec.porttitor@dolor.edu','Ponferrada','2007-08-19',0.1,'2019-11-03'),(14,'KKGLIPJO8','Hiram','Duffy','porta@amalesuada.net','Palencia','1996-05-16',NULL,'2019-09-27'),(15,'OCCMNQCW1','Kamal','Delaney','Donec.nibh@etmagnisdis.net','Salamanca','2001-07-21',0.1,'2019-12-03'),(16,'WFQZJRMQ8','Maris','Wilson','ligula.tortor@dictumultriciesligula.co.uk','Ponferrada','2003-03-01',0.1,'2019-06-12'),(17,'ASITBSEM2','Walker','Farley','ullamcorper@facilisisfacilisismagna.org','Zamora','1985-03-11',0.1,'2020-07-29'),(18,'IPJHZJRR1','Branden','Copeland','Pellentesque.ut@molestie.ca','Leon','1990-12-11',0.1,'2019-09-26'),(19,'QNTVGRYI7','Wang','Patterson','vulputate.eu.odio@ipsumCurabiturconsequat.org','Ponferrada','2007-03-12',0.1,'2018-10-28'),(20,'WIDCMVYQ3','Chaim','Mills','dis@tellusSuspendissesed.net','Salamanca','1987-01-03',0.1,'2019-10-25'),(21,'JCOEMOFK6','Norman','Stewart','a.purus@afeugiattellus.net','Palencia','1996-10-18',NULL,'2018-08-10'),(22,'EANLDCKY9','Wylie','Duran','lobortis@eratSednunc.edu','Burgos','2004-03-24',0.1,'2019-10-29'),(23,'DHOYCSHQ4','Curran','Peck','Class.aptent@Aliquameratvolutpat.org','Zamora','1994-05-19',0.1,'2018-06-26'),(24,'LVGUZXFQ1','Cherokee','Lindsey','Aliquam@sagittissemperNam.ca','Leon','1999-01-09',0.1,'2019-03-12'),(25,'TUVNKPAK3','Logan','Carr','dictum.eu.eleifend@bibendum.edu','Salamanca','1980-01-06',0.1,'2018-09-25'),(26,'EOHHKYIV5','Todd','Contreras','sit.amet.consectetuer@sapien.org','Zamora','1986-09-15',0.1,'2020-01-29'),(27,'QVIEMHUI7','Eaton','Mcclure','sit.amet@sed.net','Leon','1993-12-11',0.1,'2019-10-20'),(28,'DEMUXVXN1','Fiona','Benjamin','eget.venenatis@eutemporerat.net','Palencia','2000-09-25',NULL,'2020-09-30'),(29,'LZSZGUPV3','Akeem','Sanchez','ipsum.porta.elit@aliquam.ca','Zamora','1990-04-25',0.1,'2020-01-16'),(30,'WBYYJYYE2','Raja','Cotton','Nunc.mauris.elit@consectetueripsumnunc.net','Salamanca','1980-08-31',0.1,'2020-04-27'),(31,'WXVBCDFM0','Vincent','Levine','rutrum@Nuncmauris.org','Ponferrada','1993-07-14',0.1,'2018-08-24'),(32,'RQFQQQAS7','Wynter','Rodriguez','et.tristique@purusMaecenaslibero.ca','Zamora','1998-10-16',0.1,'2020-05-25'),(33,'XTXVGYFR9','Anika','Mcpherson','ac@velitAliquamnisl.edu','Burgos','1998-11-10',0.1,'2020-03-12'),(34,'IMHZJBAX8','Jordan','Hopper','Duis@nequeNullam.org','Ponferrada','1997-02-24',0.15,'2020-07-21'),(35,'YUKODMDP6','Yuli','Durham','nunc.interdum@dolorsit.ca','Palencia','1998-07-21',NULL,'2019-03-04'),(36,'CBLDGBSN1','Alec','Moses','Cum@interdumSed.ca','Leon','1983-04-11',0.15,'2019-08-14'),(37,'YFYVYDWG8','Kaitlin','Cherry','dictum.eleifend.nunc@penatibuset.ca','Ponferrada','1986-10-19',0.15,'2019-04-23'),(38,'WKFNRJPW8','Prescott','Boyle','Sed.auctor.odio@semut.com','Zamora','2003-02-20',0.15,'2019-02-20'),(39,'YAFTFUHD2','Rogan','Ashley','ullamcorper.Duis.cursus@Sedneque.com','Leon','2006-12-26',0.15,'2018-02-25'),(40,'DBMIEHAS3','James','Coffey','dolor@idrisus.edu','Salamanca','2004-01-24',0.15,'2019-07-28'),(41,'VWVBQSWK6','Serena','Combs','pede@Sed.co.uk','Zamora','1991-07-05',0.15,'2018-04-07'),(42,'PRMAIYVS7','Mira','Donovan','accumsan@Utsagittislobortis.ca','Palencia','1984-07-17',NULL,'2019-01-30'),(43,'MUUCLKSD8','Aristotle','Vinson','ipsum.nunc.id@vehiculaaliquetlibero.co.uk','Ponferrada','2001-05-20',0.15,'2019-07-24'),(44,'QPHQFGHT4','Ginger','Clemons','diam.lorem.auctor@necluctus.edu','Burgos','1982-03-03',0.15,'2018-08-13'),(45,'OWBDLNHJ6','Kristen','Anderson','magna.Cras.convallis@nisi.net','Salamanca','2004-05-25',0.15,'2018-02-01'),(46,'HRDBSQZH3','Tashya','Matthews','ac@neque.co.uk','Ponferrada','1995-12-30',0.15,'2019-04-06'),(47,'HTXDALSY5','Amity','Carson','dapibus.ligula.Aliquam@mauriselitdictum.ca','Zamora','2003-10-27',0.15,'2019-09-03'),(48,'NVOWSMIA4','Alden','Pollard','nunc@eleifendnon.org','Leon','2004-11-15',0.15,'2019-04-21'),(49,'NHWHSDMA5','Jolene','Morrow','mattis@Integervitaenibh.net','Palencia','2001-05-28',NULL,'2019-04-10'),(50,'GVDKJEGK7','Harrison','Walls','scelerisque@Crassed.org','Salamanca','1988-10-31',0.15,'2019-03-16'),(51,'FVBPMXLC6','Fay','Crane','porttitor@Quisqueornaretortor.org','Leon','2005-03-10',0.15,'2020-04-03'),(52,'DWNGJQWA2','Lane','Sutton','Aenean.euismod@dolor.com','Ponferrada','1987-06-17',0.15,'2019-05-17'),(53,'QPGPOCYU3','Charde','Riggs','Morbi.neque.tellus@tempor.com','Zamora','1987-08-15',0.15,'2019-05-07'),(54,'XQTMDHYH3','William','Hutchinson','sit.amet.metus@tempor.edu','Leon','1998-05-31',0.15,'2019-11-23'),(55,'BLBXPJCC1','Bryar','Joseph','convallis.in.cursus@eutelluseu.co.uk','Burgos','1999-12-10',0.15,'2019-10-07'),(56,'RZCALXCL8','Mason','Baker','sed.dui.Fusce@in.com','Palencia','2003-12-21',NULL,'2020-06-10'),(57,'EBEEBPTQ7','Ian','Bray','Sed@egestasSedpharetra.org','Leon','1996-06-09',0.15,'2020-07-17'),(58,'ANNYTNEY5','Ray','Hunter','ipsum.dolor.sit@gravida.org','Ponferrada','2000-03-13',0.15,'2019-04-28'),(59,'YARUFPJL2','Keelie','Horn','quam.dignissim@neceuismodin.net','Zamora','2001-07-25',0.15,'2018-05-27'),(60,'WYXVOSNM1','Ariel','Avery','mauris.aliquam@ullamcorpervelit.net','Salamanca','1996-07-06',0.15,'2018-02-18'),(61,'WEWTXYNX9','Lester','Cain','eget@sem.ca','Ponferrada','1999-03-26',0.15,'2019-04-10'),(62,'RDMZMEWR0','Victor','Clarke','conubia.nostra@molestie.com','Zamora','1980-03-13',0.15,'2019-07-19'),(63,'SBMYOZDN7','Faith','Martinez','orci.Donec@nuncnulla.edu','Palencia','1992-07-22',NULL,'2019-01-19'),(64,'ISELGBJC8','Gage','Snow','fermentum@pulvinar.edu','Ponferrada','1981-10-30',0.15,'2018-08-18'),(65,'IXUFCMRO8','Isaac','Koch','est@Integerurna.org','Salamanca','1985-05-21',0.15,'2019-06-22'),(66,'LKTQNZES5','Abel','Casey','ante.Nunc@convallisest.ca','Burgos','1998-11-30',0.15,'2020-08-11'),(67,'YPVVKQJP6','Samantha','Dennis','justo@vitaeodio.com','Ponferrada','2001-09-29',0.15,'2019-08-23'),(68,'EGXEDNZQ9','Lacota','Norman','et.magnis@Ut.co.uk','Zamora','1987-08-13',0.15,'2020-07-15'),(69,'HMJSMXSE5','Demetrius','Armstrong','ultrices.Duis.volutpat@Donec.edu','Leon','2005-04-04',0.15,'2018-09-24'),(70,'IZEMMKHY5','Timothy','Koch','ullamcorper@suscipitest.org','Palencia','1983-09-08',NULL,'2018-11-20'),(71,'SOCHEGRU8','Christian','Garrett','ipsum@vitaesodales.org','Zamora','1995-11-24',0.15,'2019-01-23'),(72,'NTNQLDLC0','Leilani','Rios','et.magnis@egestasFuscealiquet.org','Leon','1992-09-02',0.15,'2019-01-27'),(73,'PDODJWMG3','Julian','Brooks','augue.Sed.molestie@interdumenimnon.edu','Ponferrada','1992-07-03',0.15,'2019-02-26'),(74,'MLBJWAZV6','Mona','Rich','netus.et@sem.edu','Zamora','1995-07-22',0.15,'2019-07-23'),(75,'IPQYBCDY1','Clare','Mathis','metus.urna.convallis@est.edu','Salamanca','2006-07-05',0.15,'2019-01-13'),(76,'PJPLQYNW0','Baxter','Mccormick','consectetuer.rhoncus@nascetur.org','Ponferrada','1995-05-05',0.15,'2018-10-03'),(77,'AVRTLZVW5','Kaden','Luna','sagittis@enimEtiam.ca','Burgos','1993-11-12',NULL,'2018-05-27'),(78,'DPNMBHCO1','Xander','Langley','scelerisque.sed@enim.edu','Leon','2003-05-18',0.15,'2019-04-02'),(79,'WKQWSRDL4','Basil','Gilmore','Sed.pharetra.felis@dui.org','Ponferrada','2001-06-24',0.15,'2020-07-17'),(80,'GUTTGAYK5','Tucker','Cochran','auctor.velit.Aliquam@molestie.org','Salamanca','1980-01-27',0.15,'2020-08-29'),(81,'PAIQKBXU7','Patience','Barrett','ipsum.Phasellus.vitae@urna.net','Leon','2004-12-26',0.15,'2018-06-28'),(82,'AYEPDZDS3','Ashton','Banks','tincidunt.vehicula@nonvestibulumnec.com','Ponferrada','1980-01-21',0.15,'2019-06-17'),(83,'HSULGUUO2','Brett','Olsen','suscipit.nonummy.Fusce@tempor.com','Zamora','1983-01-13',0.15,'2020-05-08'),(84,'IQONWLNZ6','Fuller','Fields','urna.justo.faucibus@Nullam.co.uk','Palencia','2003-11-14',NULL,'2019-09-11'),(85,'WIXBPQNF2','Brenna','Parsons','Nunc.laoreet.lectus@fringillaornareplacerat.com','Salamanca','2003-06-19',0.15,'2019-03-13'),(86,'OJWUGFCN4','Gretchen','Hawkins','massa.Integer@mollis.org','Zamora','1981-02-06',0.15,'2020-08-18'),(87,'HWYFHKSB1','Gil','Fulton','rhoncus@cursusdiam.edu','Leon','1993-05-31',0.15,'2019-05-21'),(88,'HKOWKLQF9','Katelyn','Sandoval','Phasellus.dolor.elit@sed.edu','Burgos','1987-01-08',0.15,'2018-06-15'),(89,'AOPRGBAG7','Ciaran','Burton','a.feugiat@tristique.org','Zamora','1980-11-24',0.15,'2019-01-04'),(90,'LZIEQRNW9','Jessamine','Chavez','vitae.sodales@perconubia.org','Salamanca','2000-04-24',0.15,'2019-07-20'),(91,'LHSLIMWB5','Aretha','Barton','Vivamus@orciUtsagittis.com','Palencia','1998-12-29',NULL,'2019-01-26'),(92,'FCYBOBTZ1','Abigail','Castillo','gravida.Aliquam.tincidunt@eu.net','Zamora','1995-04-23',0.15,'2018-03-23'),(93,'QMBNHCAY7','Boris','Spears','metus.urna.convallis@luctus.co.uk','Leon','2005-11-26',0.15,'2020-10-06'),(94,'ZILUWQEL3','Stephen','House','nisl.sem.consequat@ante.com','Ponferrada','1990-10-22',0.15,'2019-12-16'),(95,'XXMOGNUB2','Cherokee','Le','auctor@euismodin.edu','Salamanca','1994-02-11',0.15,'2018-06-04'),(96,'ADMEIXMJ1','Suki','Gonzales','aliquet@maurisut.ca','Leon','1986-12-23',0.15,'2018-08-04'),(97,'WKTYVQWK1','Stewart','Wiley','sem@nasceturridiculusmus.edu','Ponferrada','1997-07-02',0.15,'2019-11-30'),(98,'ZFXFECAX0','Bruce','Johnston','Maecenas.iaculis@velitQuisque.co.uk','Palencia','2001-03-24',NULL,'2020-03-23'),(99,'PHPYKOAJ5','Sylvester','Hardin','egestas.lacinia.Sed@tristiquealiquet.co.uk','Burgos','2001-12-30',0.15,'2019-08-08'),(100,'MLQUFGFQ6','Imelda','Vazquez','natoque@consectetuer.net','Salamanca','1982-07-29',0.15,'2018-12-08');
/*!40000 ALTER TABLE `usuarios` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2023-03-26  0:11:41
